Attribute VB_Name = "adt8960"
Option Explicit
'****************************** Basic library functions **************** ************
Declare Function adt8960_initial Lib "adt8960m.dll" () As Integer
'************************************************* ****************************
'Function: initialize card
'Return value> 0, that the number of 8960 cards. If 3, the following card numbers were available 0,1,2
'Return value = 0, that 8960 card is not installed
'Return value <0, -1 port drivers not installed, -2 indicated a problem with PCI bridge.
'************************************************* ****************************

Declare Function adt8960_set_pulse_mode Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer, ByVal dir_logic As Integer) As Integer
'************************************************* ****************************
'Function: Set the output pulse of the work
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Value 0: Pulse + Pulse Mode 1: Pulse + direction method
'Logic 0: positive logic pulse 1: Negative logic pulse
'Dir-logic 0: the direction of the output signal is logic 1: negative logic output signal of the direction of
'Return value 0: the right 1: Error
'Default mode: Pulse + direction, positive logic pulse and direction output signal is logic
'************************************************* ****************************

Declare Function adt8960_set_limit_mode Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal v1 As Integer, ByVal v2 As Integer, ByVal dir_logic As Integer) As Integer
'************************************************* ****************************
'Function: Set the positive and negative direction limit input signal mode nLMT
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'V1 0: 1 is the effective limit: Limit is invalid
'V2 0: negative limit effective 1: Negative limit is invalid
'Logic 0: active low 1: active high
'Return value 0: the right 1: Error
'Default mode is: is the effective limit the negative limit, active-low
'************************************************* ****************************

Declare Function adt8960_set_stop0_mode Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal v As Integer, ByVal logic As Integer) As Integer
'************************************************* ****************************
'Function: Set the mode input signal stop0
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'V 0: Invalid 1: Valid
'Logic 0: active low 1: active high
'Return value 0: the right 1: Error
'Default mode: Invalid
'************************************************* ****************************

Declare Function adt8960_set_stop1_mode Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal v As Integer, ByVal logic As Integer) As Integer
'************************************************* ****************************
'Function: Set the mode input signal stop1
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'V 0: Invalid 1: Valid
'Logic 0: active low 1: active high
'Return value 0: the right 1: Error
'Default mode: Invalid
'************************************************* ****************************

Declare Function adt8960_get_status Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef value As Integer) As Integer
'************************************************* ****************************
'Function: get the axis of the drive state
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'V-driven state pointer
'0: Drive end of the non-0: is driving
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_get_inp_status Lib "adt8960m.dll" (ByVal cardno As Integer, ByRef value As Integer) As Integer
'************************************************* ****************************
'Function: Get the interpolation driving status
'Parameters:
'Cardno card number
'V interpolation state pointer
'0: interpolation end of the 1: is interpolation
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_set_acc Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal add As Long) As Integer
'************************************************* ****************************
'Function: Acceleration setting
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Add the range (1 - 64000)
'The actual acceleration value add * 125
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_set_startv Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal startv As Long) As Integer
'************************************************* ****************************
'Function: the initial speed setting
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Startv range (1-2M),
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_set_speed Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal speed As Long) As Integer
'************************************************* ****************************
'Function: Drive speed setting
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Speed range (1-2M)
'Return value 0: the right 1: Error
'************************************************* ****************************


Declare Function adt8960_set_command_pos Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'************************************************* ****************************
'Function: Logic position setting
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Value range (-2147483648 ~ +2147483647)
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_set_actual_pos Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'************************************************* ****************************
'Function: Set the actual location of
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Value range (-2147483648 ~ +2147483647)
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_set_symmetry_speed Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************** Set acceleration ******************* *****
'Function: Set the value of acceleration
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Lspd initial velocity
'Hspd drive speed
'Tacc acceleration time
'Vacc acceleration of the rate of change
'Mode accelerating mode (0: trapezoidal, 1: S-type)
'Return value 0: the right 1: Error
'************************************************* *****************/

Declare Function adt8960_get_command_pos Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef value As Long) As Integer
'************************************************* ****************************
'Function: The logical location for each axis
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Value logical location of the pointer
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_get_actual_pos Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef value As Long) As Integer
'************************************************* ****************************
'Function: Get the actual position of each axis
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Value pointer to the actual location
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_get_speed Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef value As Long) As Integer
'************************************************* ****************************
'Function: get the axis of the current drive speed
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Value pointer to the current driving speed
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_get_out Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal number As Integer) As Integer
'/*************************** For output state ****************** *********
'Function: Get output status
'Parameters:
'Cardno card number
'Number port
'Returns: the current state of specified port, -1 means the parameter error
'************************************************* *****************/

Declare Function adt8960_pmove Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'************************************************* ****************************
'Function: Quantitative drive
'Cardno card number
'Axis axis number (1 - 6)
'Value output pulses (-268 435 455 ~ +268435455)
'> 0: positive direction driving <0: negative direction drive
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_continue_move Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal dir As Integer) As Integer
'************************************************* ****************************
'Functions:
'Uniaxial continuous drive
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Dir driving directions
'0: positive direction 1: Negative direction
'Return value 0: the right 1: Error
'************************************************* **************/


Declare Function adt8960_dec_stop Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'************************************************* ****************************
'Function: Drive deceleration to stop
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_sudden_stop Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'************************************************* ****************************
'Function: Drive to immediately stop
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_inp_move2 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer
'************************************************* ****************************
'Function: two-axis linear interpolation
'Parameters:
'Cardno card number
'Axis1, axis2 axis number in interpolation
'Pulse1, pulse2 move relative distance (-8388608 ~ +8388607)
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_inp_move3 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer
'************************************************* ****************************
'Features: three-axis linear interpolation
'Parameters:
'Cardno card number
'Axis1, axis2, axis3 number in the axis interpolation
'Pulse1, pulse2, pulse3 move relative distance (-8388608 ~ +8388607)
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_inp_move4 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long) As Integer
'************************************************* ****************************
'Features: Four-axis linear interpolation
'Parameters:
'Cardno card number
'Axis1, axis2, axis3, axis4 number in the axis interpolation
'Pulse1, pulse2, pulse3, pulse4 axis to move relative distance (-8388608 ~ +8388607)
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_inp_move5 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long) As Integer
'************************************************* ****************************
'Function: five-axis linear interpolation
'Parameters:
'Cardno card number
'Axis1, axis2, axis3, axis4, axis5 number in the axis interpolation
'Pulse1, pulse2, pulse3, pulse4, pulse5 five-axis movement relative distance (-8388608 ~ +8388607)
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_inp_move6 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long) As Integer
'************************************************* ****************************
'Features: Six-axis linear interpolation
'Parameters:
'Cardno card number
'Pulse1, pulse2, pulse3, pulse4, pulse5, pulse6
'XYZABC six-axis the relative distance (-8388608 ~ +8388607)
'Return value 0: the right 1: Error
'************************************************* ****************************


Declare Function adt8960_read_bit Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal number As Integer) As Integer
'************************************************* ****************************
'Function: read input
'Parameters:
'Cardno card number
'Number input (0 - 31)
'Return value 0: Low 1: High -1: Error
'************************************************* ****************************

Declare Function adt8960_write_bit Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal number As Integer, ByVal value As Integer) As Integer
'************************************************* ****************************
'Function: Output
'Parameters:
'Cardno card number
'Number outputs (0 - 15)
'Value 0: Low 1: High
'Return value 0: the right 1: Error
'************************************************* ****************************

Declare Function adt8960_get_lib_version Lib "adt8960m.dll" (ByVal cardno As Integer) As Integer
'/************** Function: get the current library version **************
'Back to the hardware and the library version is the version number of the combination of
'************************************************/


Declare Function adt8960_get_hardware_ver Lib "adt8960m.dll" (ByVal cardno As Integer) As Single
'************************************************* ****************************
''Features: Get hardware version
'Parameters:
'Cardno card number
'Return value 256: the hardware first edition
'************************************************* ****************************

Declare Function adt8960_set_suddenstop_mode Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal v As Integer, ByVal logic As Integer) As Integer
'************************************************* ****************************
'Function: hardware stop mode
'Parameters:
'Cardno card number
'V 0: Invalid 1: Valid
'Logic 0: active low 1: active high
'Return value 0: the right 1: Error
'Hardware terminal stop signal plate 33 fixed to use J2 pin (IN31)
'************************************************* ****************************

Declare Function adt8960_set_io_mode Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal v1 As Integer, ByVal v2 As Integer) As Integer
'*************************** Set the delay time ***************** *************
'Functions:
'Set the delay time
'Parameters:
'V1 0: 8 points in front of the input is defined as 1: 8 points in front of the output is defined as

'V2 0: 8 points behind the input is defined as 1: 8 points behind is defined as the output

'Return value 0: the right 1: Error

'Note: When the IO point when used as outputs and can also read the input status
'************************************************* ********************

Declare Function adt8960_set_delay_time Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal time As Long) As Integer
'************************************************* ****************************
'Function: Set the delay time
'Parameters:
'Cardno card number
'Time delay
'Return value 0: the right 1: Error
'Time units 1/8us
'************************************************* ****************************

Declare Function adt8960_get_delay_status Lib "adt8960m.dll" (ByVal cardno As Integer) As Integer
'************************************************* ****************************
'Function: Get the state delay
'Parameters:
'Cardno card number
'Return value 0: 1 end delay: delay in progress
'************************************************* ****************************

'//*********************************************//
'/ / Composite driver class / /
'//*********************************************//

Declare Function adt8960_symmetry_relative_move Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'************************************************* *******
'* Function: single-axis linear interpolation relative motion, with reference to the current position, move to accelerate the quantitative
'* Parameters:
'Cardno - card number
'Axis --- axis No.
'Pulse - pulse
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'Return value 0: the right 1: Error
'************************************************* ********/

Declare Function adt8960_symmetry_absolute_move Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************************************ *********
'* Function: single-axis linear interpolation absolute motion, with reference to the zero position, in order to speed up the quantitative movement
'* Parameters:
'Cardno - card number
'Axis --- axis No.
'Pulse - pulse
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'Return value 0: the right 1: Error
'************************************************* *********/

Declare Function adt8960_symmetry_relative_line2 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************************************ **********
'* Function: relative motion of two-axis linear interpolation with reference to the current location to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'Return value 0: the right 1: Error
'************************************************* **********/

Declare Function adt8960_symmetry_absolute_line2 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************************************ ***********
'* Function: two-axis linear interpolation absolute motion, with reference to the zero position, in order to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'Return value 0: the right 1: Error
'************************************************* ***********/

Declare Function adt8960_symmetry_relative_line3 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************************************ ************
'* Function: three-axis linear interpolation relative motion, with reference to the current location to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'Return value 0: the right 1: Error
'************************************************* **************/

Declare Function adt8960_symmetry_absolute_line3 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************************************ **************
'Function: linear interpolation axis absolute motion, with reference to the zero position, in order to speed up the linear interpolation
'Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'Return value 0: the right 1: Error
'************************************************* ***************/

Declare Function adt8960_symmetry_relative_line4 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************************************ ****************
'* Function: Four-axis linear interpolation relative motion, with reference to the current location to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Axis4 --- Shaft No. 4
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'************************************************* ***************/


Declare Function adt8960_symmetry_absolute_line4 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************************************ ***************
'* Function: absolute motion axis linear interpolation with reference to the zero position, to acceleration and deceleration in a straight line interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Axis4 --- Shaft No. 4
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'************************************************* ***************/

Declare Function adt8960_symmetry_relative_line5 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/***************** Axis linear interpolation relative motion ****************
'* Function: with reference to the current location to acceleration and deceleration in a straight line interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Axis4 --- Shaft No. 4
'Axis5 --- No. 5 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Pulse5 - Pulse 5
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'************************************************* *****/

Declare Function adt8960_symmetry_absolute_line5 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/***************** Symmetry axis linear interpolation absolute motion ****************
'* Function: with reference to the zero position, acceleration and deceleration for the symmetric linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Axis4 --- Shaft No. 4
'Axis5 --- No. 5 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Pulse5 - Pulse 5
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'************************************************* *****/

Declare Function adt8960_symmetry_relative_line6 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/***************** Six-axis linear interpolation relative motion ****************
'* Function: with reference to the current location to acceleration and deceleration in a straight line interpolation
'* Parameters:
'Cardno - card number
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Pulse5 - Pulse 5
'Pulse6 - Pulse 6
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'************************************************* *****/

Declare Function adt8960_symmetry_absolute_line6 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'***************** Six-axis absolute motion **************** symmetric linear interpolation
'* Function: with reference to the zero position, acceleration and deceleration for the symmetric linear interpolation
'* Parameters:
'Cardno - card number
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Pulse5 - Pulse 5
'Pulse6 - Pulse 6
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Vacc --- acceleration of the rate of change
'Mode --- accelerating mode (0: trapezoidal, 1: S-type)
'************************************************* *****/


'//----------------------------------------------- -----//
'/ / 2008.10.6 / /
'//----------------------------------------------- -----//
Declare Function adt8960_set_acac Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'/******************* Functions: acceleration / deceleration rate of change of setting ****************** **
'Cardno card number
'Axis axis No.
'Value K value (1 - 65535)
'The actual change rate 1000000 / k
'Return value 0: the right 1: Error
'************************************************* *****************/

Declare Function adt8960_set_ad_mode Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal mode As Integer) As Integer
'/********************* Functions: acceleration / deceleration mode setting ****************** ****
'Cardno card number
'Axis axis number (1 - 4)
'Mode 0: Linear acceleration / deceleration 1: S curve acceleration / deceleration
'Return value 0: the right 1: Error
'Default mode: linear acceleration / deceleration
'************************************************* *****************/

Declare Function adt8960_get_ad Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef ad As Long) As Integer
'/******************* Function: get the axis of the current acceleration *********************
'Cardno card number
'Axis axis No.
'Ad a pointer to the current acceleration
'Return value 0: the right 1: Error
'Data-driven acceleration of the unit and set the value of A as
'************************************************* *****************/

'//----------------------------------------------- -----//
'/ / External signal driver / /
'//----------------------------------------------- -----//
Declare Function adt8960_manual_continue Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'/******************* Function: a continuous external signal driver *********************
'Cardno card number
'Axis axis No.
'Return value 0: the right 1: Error
'Note: (1) a continuous pulse, but the driver does not immediately need to wait until the external signal level changes
'(2) You can use an ordinary button, you can also take over the wheel
'************************************************* *****************/

Declare Function adt8960_manual_pmove Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pos As Long) As Integer
'/******************* Function: an external signal quantitatively driven *********************
'Cardno card number
'Axis axis No.
'Return value 0: the right 1: Error
'Note: (1) a quantitative pulse, but the driver does not immediately need to wait until the external signal level changes
'(2) You can use an ordinary button, you can also take over the wheel
'************************************************* *****************/

Declare Function adt8960_manual_disable Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'/*********************** Driven off the external signal that can ******************* ****
'Function: turn off the external drive enable signal
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Return value 0: the right 1: Error
'************************************************* *****************/

'//----------------------------------------------- -----//
'/ / Position latch / /
'//----------------------------------------------- -----//
Declare Function adt8960_set_lock_position Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal mode As Integer, ByVal regi As Integer, ByVal logical As Integer) As Integer
'/**************************** Position latch set function *************** *******
'Function: signaling functions set in place, lock all the axes and the actual location of the logical location
'Parameters:
'Axis-reference axis
'Mode-latch mode | 0: Invalid
'| 1: Effective
'Regi-counter mode | 0: logical location
'| 1: actual position
'Logical-level signal | 0: rising edge
'| 1: falling
'Return value 0: the right 1: Error
'Note: Use the specified axis axis of the IN signal as the trigger signal
'************************************************* ******************/

Declare Function adt8960_get_lock_status Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef v As Integer) As Integer
'/************************* Latch operation for the state of ***************** ******
'Function: Get the status latch operations
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'V 0 | not perform latch operation
'1 | latch operation performed
'Return value 0: the right 1: Error
'Note: Use this function to capture the position of whether to implement latch
'************************************************* *****************/

Declare Function adt8960_get_lock_position Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef pos As Long) As Integer
'/************************** Get locked position ****************** ********
'Function: Get the locked position
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Pos position latch
'Return value 0: the right 1: Error
'************************************************* *****************/

Declare Function adt8960_clr_lock_status Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'/************************** Clear lock ******************** ******
'Function: Clear Lock
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Return value 0: the right 1: Error
'************************************************* *****************/

'//----------------------------------------------- -----//
'/ / Hardware cache / /
'//----------------------------------------------- -----//
Declare Function adt8960_fifo_inp_move1 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal pulse1 As Long, ByVal speed As Long) As Integer
'/************************** Uniaxial cache ******************* *******
'Function: Single Cache
'Parameters:
'Cardno card number
'Axis1 axis number (1 - 6)
'Pulse1 cache pulse
'Speed cache speed
'Return value 0: the right 1: Error
'Note: A total of 2048 buffer space, each occupied by three single-axis instruction cache space, instruction cache 682
'************************************************* *****************/

Declare Function adt8960_fifo_inp_move2 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal speed As Long) As Integer
'/************************** Two axes cache ******************* *******
'Function: two-axle cache
'Parameters:
'Cardno card number
'Axis1 axis number (1 - 6)
'Axis2 axis number (1 - 6)
'Pulse1 cache pulses
'Pulse2 cache pulses
'Speed cache speed
'Return value 0: the right 1: Error
'Note: A total of 2048 buffer space, and each instruction takes two 4-axis cache space, instruction cache 512
'************************************************* *****************/

Declare Function adt8960_fifo_inp_move3 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal speed As Long) As Integer
'/************************** Axis cache ******************* *******
'Function: Axis Cache
'Parameters:
'Cardno card number
'Axis1 axis number (1 - 6)
'Axis2 axis number (1 - 6)
'Axis3 axis number (1 - 6)
'Pulse1 cache pulses
'Pulse2 cache pulses
'Pulse3 cache pulses
'Speed cache speed
'Return value 0: the right 1: Error
'Note: A total of 2048 buffer space, each instruction takes 5 axis cache space, instruction cache 409
'************************************************* *****************/

Declare Function adt8960_fifo_inp_move4 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal speed As Long) As Integer
'/************************** Axis cache ******************* *******
'Function: axis cache
'Parameters:
'Cardno card number
'Axis1 axis number (1 - 6)
'Axis2 axis number (1 - 6)
'Axis3 axis number (1 - 6)
'Axis4 axis number (1 - 6)
'Pulse1 cache pulses
'Pulse2 cache pulses
'Pulse3 cache pulses
'Pulse4 cache pulses
'Speed cache speed
'Return value 0: the right 1: Error
'Note: A total of 2048 buffer space, each axis takes 6 instruction cache space, instruction cache 341
'************************************************* *****************/

Declare Function adt8960_fifo_inp_move5 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal speed As Long) As Integer
'/************************** Axis cache ******************* *******
'Function: Axis Cache
'Parameters:
'Cardno card number
'Axis1 axis number (1 - 6)
'Axis2 axis number (1 - 6)
'Axis3 axis number (1 - 6)
'Axis4 axis number (1 - 6)
'Axis5 axis number (1 - 6)
'Pulse1 cache pulses
'Pulse2 cache pulses
'Pulse3 cache pulses
'Pulse4 cache pulses
'Pulse5 cache pulses
'Speed cache speed
'Return value 0: the right 1: Error
'Note: A total of 2048 buffer space occupied by each axis 7 instruction cache space, instruction cache 292
'************************************************* *****************/

Declare Function adt8960_fifo_inp_move6 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal speed As Long) As Integer
'/************************** Six-axis cache ******************* *******
'Function: six-axis cache
'Parameters:
'Cardno card number
'Pulse1 cache pulses
'Pulse2 cache pulses
'Pulse3 cache pulses
'Pulse4 cache pulses
'Pulse5 cache pulses
'Pulse6 cache pulses
'Speed cache speed
'Return value 0: the right 1: Error
'Note: A total of 2048 buffer space occupied by each six-axis 8 instruction cache space, instruction cache 256
'************************************************* *****************/

Declare Function adt8960_reset_fifo Lib "adt8960m.dll" (ByVal cardno As Integer) As Integer
'/************************** Reset cache ******************* *******
'Function: Clear Cache
'Parameters:
'Cardno card number
'Return value 0: the right 1: Error
'************************************************* *****************/

Declare Function adt8960_read_fifo_count Lib "adt8960m.dll" (ByVal cardno As Integer, ByRef value As Integer) As Integer
'/************************** Number ****************** read caching ****
'Function: the number of read cache and store instructions into the number left is not running
'Parameters:
'Cardno card number
'Return value 0: the right 1: Error
'************************************************* *****************/

Declare Function adt8960_read_fifo_empty Lib "adt8960m.dll" (ByVal cardno As Integer) As Integer
'/************************** Read cache state ****************** ****
'Function: read cache is empty
'Parameters:
'Cardno card number
'Return value 0: non-empty 1: Empty
'************************************************* *****************/

Declare Function adt8960_read_fifo_full Lib "adt8960m.dll" (ByVal cardno As Integer) As Integer
'/************************** Read cache state ****************** ****
'Function: read cache is full, full, the data will no longer exist
'Parameters:
'Cardno card number
'Return value 0: less than 1: full
'************************************************* *****************/

'//*********************************************** ***************************//
'/ / ************* ************* Manual deceleration / /
'/ / First need to set the manual deceleration mode / /
'/ / When the manual deceleration mode is active, set the manual deceleration point pos1 / /
'/ / Set point offset pos2 / /
'/ / Set the speed of manual deceleration point (low speed) endspeed / /
'/ / Manual deceleration movement: Movement to the deceleration point automatically slow down to endspeed pos1 run / /
'/ / To speed endspeed search for the origin signal, origin of the signal the need for external signal trigger (stop0 the low level trigger) / /
'/ / When the origin signal is triggered, the origin offset pos2 movement immediately after the stop / /
'//*********************************************** ***************************//
Declare Function adt8960_set_dec_mode Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal mode As Integer) As Integer
'/************************** Set manual deceleration mode ****************** ********
'Function: Set the manual deceleration mode
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Mode manual deceleration mode is invalid an effective 0
'Return value 0: the right 1: Error
'************************************************* *****************/

Declare Function adt8960_set_dec_pos1 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pos As Long) As Integer
'/************************** Set the manual deceleration point ****************** ********
'Function: Manual deceleration point setting
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Pos deceleration point
'Return value 0: the right 1: Error
'Note: to the deceleration of the deceleration point automatically to the specified low-speed movement, looking for the origin of the trigger signal,
'If you do not find the trigger signal, has been movement will continue at this rate until the end of the exercise
'************************************************* *****************/

Declare Function adt8960_set_dec_pos2 Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pos As Long) As Integer
'/************************** Gear manually specified offset **************** **********
'Function: slow down rest position
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Pos remaining positions
'Return value 0: the right 1: Error
'Note: Movement of the offset the need for external signal trigger, the trigger signal is low level stop0
'************************************************* *****************/

Declare Function adt8960_clr_dec_status Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'/************************** Clear manual deceleration state ****************** ********
'Function: the origin offset
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Return value 0: the right 1: Error
'************************************************* *****************/

Declare Function adt8960_get_dec_status Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef sta As Integer) As Integer
'/************************** For manual deceleration state ****************** ********
'Function: Get the manual deceleration state
'Parameters:
'Cardno card number
'Axis axis number (1 - 6)
'Sta deceleration state
'0: Searching
'1: the search is completed
'2: The campaign has to stop, slow down point not found
'3: did not meet the actual migration
'4: Search the servo off during deceleration point
'5: deceleration point has been found, not in place to offset movement (which may be the trigger limit, etc.)
'Return value 0: the right 1: Error
'************************************************* *****************/

Declare Function adt8960_set_end_speed Lib "adt8960m.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal speed As Long) As Integer
'Function: trailing speed setting
'Cardno card number
'Axis axis number (1 - 6)
'Speed range (1-2M)
'Return value 0: the right 1: Error
'Note: If the manual deceleration point pos1 not found after the trigger signal (slow signal origin), has been movement will continue at this rate



Public Sub MyProc()

    DoEvents

End Sub

